// EventGroup contains containers with all Events/EventGroups linked to this object. If triggered, it will Trigger all linked events and eventGroups.
/******************************************************************************/
class EventGroup : Game.Obj
{
public:
   
    EventGroup ();
   ~EventGroup();
   
   virtual void create(Object &obj);
   virtual void AfterCreate(              );
   virtual bool update();
   virtual uint drawPrepare() { return 0; }
   
   virtual void Triggered();
   
   virtual Vec    pos   (                ) { return 0; } // get position
   virtual void   pos   (C Vec    &pos   ) {           } // set position
   virtual Matrix matrix(                ) { return 0; } // get matrix
   virtual void   matrix(C Matrix &matrix) {           } // set matrix, for most classes 'matrix' should be normalized  
   
private:
      
   Memc<UID> m_EventsUID;      // Container of all event UIDs  linked to this EventGroup
   Memc<BaseEvent*> m_Events;  // Container of all events      linked to this eventGroup 
   Memc<EventGroup*> m_Groups; // Container of all eventGroups linked to this eventGroup
   bool m_CallOnGameStart, m_FirstTick; 
};
/******************************************************************************/
EventGroup::EventGroup() : m_CallOnGameStart(false), m_FirstTick(true)
{
   
}
EventGroup::~EventGroup()
{
   
}
/******************************************************************************/
void EventGroup::create(Object &obj)
{   
   if(Param *p = obj.findParam("CallOnGameStart")) m_CallOnGameStart = p.asBool();
   
   // Check for 9 events that can be triggered from this eventgroup. It's possible to increase this number if needed.
   for(int i = 1; i <= 9; ++i) 
      if(Param *p = obj.findParam(S + "OnSwitch" + i))
         if(p.asID().valid()) m_EventsUID.add(p.asID());
}
/******************************************************************************/
void EventGroup::AfterCreate()
{
   // Loop over every single event/eventGroup in the level and check if the IDs match. If so: store the event or eventgroup.
   REPAD(i, m_EventsUID)
   {
      UID tempID = m_EventsUID[i];
      
      REPAD(j, eventToggleDoors)
         if(eventToggleDoors[j].id() == tempID) m_Events.add(&eventToggleDoors[j]);
         
      REPAD(j, eventOpenDoors)
         if(eventOpenDoors[j].id() == tempID) m_Events.add(&eventOpenDoors[j]);
       
      REPAD(j, eventControlElevators)
         if(eventControlElevators[j].id() == tempID) m_Events.add(&eventControlElevators[j]);
          
      REPAD(j, eventPlaySounds)
         if(eventPlaySounds[j].id() == tempID) m_Events.add(&eventPlaySounds[j]);
         
      REPAD(j, eventStopSounds)
         if(eventStopSounds[j].id() == tempID) m_Events.add(&eventStopSounds[j]);
         
      REPAD(j, eventToggleDrawObjects)
         if(eventToggleDrawObjects[j].id() == tempID) m_Events.add(&eventToggleDrawObjects[j]);
         
      REPAD(j, eventToggleTriggers)
         if(eventToggleTriggers[j].id() == tempID) m_Events.add(&eventToggleTriggers[j]);
         
      REPAD(j, eventSpawnLight)
         if(eventSpawnLight[j].id() == tempID) m_Events.add(&eventSpawnLight[j]);
         
      REPAD(j, eventRemoveLights)
         if(eventRemoveLights[j].id() == tempID) m_Events.add(&eventRemoveLights[j]);
         
      REPAD(j, eventDrawParticles)
         if(eventDrawParticles[j].id() == tempID) m_Events.add(&eventDrawParticles[j]);
         
      REPAD(j, eventRemoveParticles)
         if(eventRemoveParticles[j].id() == tempID) m_Events.add(&eventRemoveParticles[j]);
         
      REPAD(j, eventShakeCameras)
         if(eventShakeCameras[j].id() == tempID) m_Events.add(&eventShakeCameras[j]);
         
      REPAD(j, eventDrawTexts)
         if(eventDrawTexts[j].id() == tempID) m_Events.add(&eventDrawTexts[j]);
         
      REPAD(j, eventStopDrawTexts)
         if(eventStopDrawTexts[j].id() == tempID) m_Events.add(&eventStopDrawTexts[j]);
         
      REPAD(j, eventTeleportObjects)
         if(eventTeleportObjects[j].id() == tempID) m_Events.add(&eventTeleportObjects[j]);
         
     // Set variables            
      REPAD(j, eventSetBool)
         if(eventSetBool[j].id() == tempID) m_Events.add(&eventSetBool[j]);
         
      REPAD(j, eventSetInt)
         if(eventSetInt[j].id() == tempID) m_Events.add(&eventSetInt[j]);
         
      REPAD(j, eventSetFloat)
         if(eventSetFloat[j].id() == tempID) m_Events.add(&eventSetFloat[j]);
         
      REPAD(j, eventSetVec)
         if(eventSetVec[j].id() == tempID) m_Events.add(&eventSetVec[j]);
         
      REPAD(j, eventSetString)  
         if(eventSetString[j].id() == tempID) m_Events.add(&eventSetString[j]);
         
      REPAD(j, eventSetPointLight)  
         if(eventSetPointLight[j].id() == tempID) m_Events.add(&eventSetPointLight[j]);
             
      // Check variables
      REPAD(j, eventCheckBool)
         if(eventCheckBool[j].id() == tempID) m_Events.add(&eventCheckBool[j]);
    
      REPAD(j, eventCheckInt)
         if(eventCheckInt[j].id() == tempID) m_Events.add(&eventCheckInt[j]);
             
      // Other linked EventGroup objects
      REPAD(j, eventBehaviours)
         if(eventBehaviours[j].id() == tempID) m_Groups.add(&eventBehaviours[j]);   
   }
   
   DEBUG_ASSERT(m_Events.elms() + m_Groups.elms() == m_EventsUID.elms(), "EventGroup: Not all events/eventgroups were found in the scene");
   
   // Activate the events at the start of the game
   if(m_CallOnGameStart)
   { 
      Triggered();
   }
}
/******************************************************************************/
bool EventGroup::update()
{
   // On the first frame, call AfterCreate(). This method allows you to initialize all events/objects that need to be called/referenced
   if(m_FirstTick)
   {
      AfterCreate();
      
      m_FirstTick = false;
   }
   
   return true;
}
/******************************************************************************/
void EventGroup::Triggered()
{
   REPAO(m_Events).Triggered();
   REPAO(m_Groups).Triggered();
}
/******************************************************************************/
// Global helper function
/******************************************************************************/
EventGroup* GetEventGroupForID(UID id)
{
   REPAD(i, eventBehaviours)
   {
      if(eventBehaviours[i].id() == id)
      {
         return &eventBehaviours[i];
      }
   }

   return null;
}
/******************************************************************************/
